/*******************************************************
Filename		:  FA_HABITAT_RESULT_data2.sql
Release 		:  c2.0
SIR			:  1496
Description		:  Adds additional data element to the FA_HABITAT_RESULT fact table.
Author			:  Bill Nash
Date			:  7/08/2003
Comments		:  Created based on Regular Results
	8-18-2003 -- 1496 TIR 1 added units to detection_limit -WN
	01/16/04 - SIR 1586 Moved connect string to master install script -JW
	01/22/04 --added station location point information (new fk to fa_station) -JW
	05/26/04 --add STD value and unit and updated UOM logic -JW
	6/09/2004 - added std datum columns updates. -GT
	6/21/2004 --updated unit conversion to user result_value_text and to test 0 values -JW
	09/27/2004 - fa_statn_types is read from fa_station table. -GT
 	01/19/2005 - result_comment and text result update are edited to use long_temp table.  This table has description_text fixed. Also updated other fields identified by the SIR (epa_reg_number, detection_limit_description). SIR 1677. - GT
	06/07/2005 - SIR1706. Add generated_huc and related fk columns.  -GT
 	06/09/2005 - Edited to remove references to tsrchals and tsrchar tables. - GT
**********************************************************/
spool FA_HABITAT_RESULT_data2.log

set serveroutput on
set time on

--CHAR user defined 
UPDATE FA_HABITAT_RESULT RE SET (CHARACTERISTIC_NAME, HABITAT_CLASS_NAME) =
	(SELECT hcsc.CHARACTERSTC_NAME, ch.NAME	
	FROM storet1.TSRHCSC  HCSC,
           storet1.TSRCHGRP CH
	WHERE re.FK_HCSC = HCSC.TSRHCSC_IS_NUMBER
	AND re.organization_id = HCSC.TSRHCSC_ORG_ID
      AND HCSC.TSRCHGRP_IS_NUMBER = CH.TSRCHGRP_IS_NUMBER
      AND HCSC.TSRCHGRP_ORG_ID = CH.TSRCHGRP_ORG_ID);
commit;

--CHAR system defined (overlay user defined)
UPDATE FA_HABITAT_RESULT RE SET CHARACTERISTIC_NAME =
	(SELECT CHR.DISPLAY_NAME	
	FROM storetw.di_characteristic CHR
	WHERE re.FK_CHAR = CHR.pk_isn)
   where fk_hcsc is null ;
commit;
--trip and station visit info
UPDATE FA_HABITAT_RESULT RE 
SET (STATION_ID,STATION_NAME,TRIP_ID,TRIP_NAME,STATION_VISIT_ID,TSMSTATN_IS_NUMBER,
     VISIT_START_DATE_TIME,VISIT_START_TIME_ZONE,VISIT_STOP_DATE_TIME,VISIT_STOP_TIME_ZONE) =
(SELECT st.STATION_ID,st.STATION_NAME,st.TRIP_ID,st.TRIP_NAME,st.STATION_VISIT_ID,st.TSMSTATN_IS_NUMBER,
	st.VISIT_START_DATE_TIME,st.VISIT_START_TIME_ZONE,st.VISIT_STOP_DATE_TIME,st.VISIT_STOP_TIME_ZONE	
  	from hbstatninfo_temp st
  	WHERE re.TSRSTVST_IS_NUMBER = ST.TSRSTVST_IS_NUMBER
	AND re.ORGANIZATION_ID = ST.TSRSTVST_ORG_ID);
commit;

--STATION and STATION LOCATION INFO (updated on 06-09-04)
update FA_HABITAT_RESULT re set (fk_station,
		re.fk_org, 
		re.fk_db_cat,
		re.fk_gen_db_cat,
		re.fk_geo_county,
		re.fk_geo_state,
		re.fk_mad_hdatum,
		re.fk_mad_hmethod,
		re.stn_latitude,
		re.stn_longitude,
                re.stn_hdatum,
                re.stn_std_latitude,
                re.stn_std_longitude,
                re.stn_std_hdatum,
		re.hydrologic_unit_code,
		re.generated_huc,
		re.sgo_indicator,
		re.fk_statn_types)=
	(select st.pk_isn,
		st.fk_org,
		st.fk_db_cat,
		st.fk_gen_db_cat,
		st.fk_geo_county,
		st.fk_geo_state,
		st.fk_mad_hdatum,
		st.fk_mad_hmethod,
		st.latitude,
		st.longitude,
		stn_hd.id_code,
                st.std_latitude,
                st.std_longitude,
		stn_std_hd.id_code,
		st.hydrologic_unit_code,
		st.generated_huc,
		st.sgo_indicator,
		st.fk_statn_types
	from fa_station st,
      	     lu_mad_hdatum stn_hd,
 	     lu_mad_hdatum stn_std_hd
	where st.organization_id = re.organization_id
	and st.station_is_number = re.tsmstatn_is_number
   	and st.fk_mad_hdatum = stn_hd.pk_isn(+)
    	and st.fk_std_hdatum = stn_std_hd.pk_isn(+)
	and st.location_point_type = '*POINT OF RECORD');
commit;
/**
--RESULT UOM
UPDATE FA_HABITAT_RESULT RE SET RESULT_UNIT =
	(SELECT RSLTUOM.SHORT_FORM_NAME
	FROM storet.TSRUOM RSLTUOM
	WHERE re.TSRUOM_IS_NUMBER = RSLTUOM.TSRUOM_IS_NUMBER
  	AND RSLTUOM.TSRUOM_ORG_ID = 'ZZZZZZZZ');
commit;

UPDATE FA_HABITAT_RESULT RE
	SET (RESULT_UNIT,STD_VALUE,STD_UNIT) = (SELECT SHORT_FORM_NAME, CASE tsruom_is_number 
		WHEN 201 THEN (RE.RESULT_VALUE - 32) * conversion_factor 
		WHEN 202 THEN (RE.RESULT_VALUE - 273.15)
		ELSE RESULT_VALUE * conversion_factor END, target_unit
	from lu_unit_conversion uc
	where tsruom_is_number = uc.pk_isn);
commit;
**/
--Populate Result Unit, STD unit and STD value columns
--account for temperature conversion shift for F and K (tsruom_is_Number 201 and 202) to C
--use result_value if result_value_text is not a valid number
--std value should not be 0 when result_value is 0 but result_value_text is blank
UPDATE FA_HABITAT_RESULT RE
	SET (RESULT_UNIT,STD_VALUE,STD_UNIT) = (SELECT SHORT_FORM_NAME, CASE FK_UNIT_CONVERSION 
		WHEN 201 THEN (RE.RESULT_VALUE - 32) * conversion_factor 
		WHEN 202 THEN (RE.RESULT_VALUE - 273.15)
		ELSE (CASE WHEN ((length(ltrim(rtrim(result_value_text,'0123456789-+. '),'0123456789-+. ')) > 0) OR
			length(ltrim(rtrim(result_value_text,'-+. '),'-+. ')) is null) AND	
			result_value_text <> ' ' THEN result_value ELSE
			to_number(ltrim(rtrim(result_value_text))) END) * conversion_factor END, target_unit
	from lu_unit_conversion uc
	where FK_UNIT_CONVERSION = uc.pk_isn);
commit;

--activity attributes
-- 01-22-2004 - added tsmalp_is_number
--06-09-2004 - added std_datum info.
update FA_HABITAT_RESULT RE
set (LOCATION_POINT_TYPE    ,
tsmalp_is_number,
POINT_SEQUENCE_NUMBER  ,
WELL_NUMBER            ,
PIPE_NUMBER            ,
ACTIVITY_LATITUDE      ,
ACTIVITY_LONGITUDE     ,
FK_ACT_MAD_HDATUM      ,
FK_ACT_MAD_HMETHOD     ,
ACT_STD_LATITUDE       ,
ACT_STD_LONGITUDE      ,
act_STD_HDATUM  ,
activity_isn		,
POINT_NAME			,
MAP_SCALE) =  
(select b.LOCATION_POINT_TYPE    ,
b.tsmalp_is_number,
b.POINT_SEQUENCE_NUMBER  ,
b.WELL_NUMBER            ,
b.PIPE_NUMBER            ,
b.ACTIVITY_LATITUDE      ,
b.ACTIVITY_LONGITUDE     ,
b.FK_ACT_MAD_HDATUM      ,
b.FK_ACT_MAD_HMETHOD     ,
b.ACT_STD_LATITUDE       ,
b.ACT_STD_LONGITUDE      ,
b.act_STD_HDATUM  ,
b.activity_isn		,
b.POINT_NAME			,
b.MAP_SCALE
from hbfdact_temp2 b
where re.activity_is_number = b.activity_is_number
and  re.organization_id = b.organization_id);
commit;

--ANALYTICAL PROCEDURE
UPDATE FA_HABITAT_RESULT RE SET (ANALYTICAL_PROCEDURE_SOURCE,ANALYTICAL_PROCEDURE_ID) =
	(SELECT ANLPR.SOURCE_ACR,
		ANLPR.PROCEDURE_ID	
	FROM storet1.TSRANLPR ANLPR
	WHERE re.TSRANLPR_IS_NUMBER = ANLPR.TSRANLPR_IS_NUMBER
	AND re.TSRANLPR_ORG_ID = ANLPR.TSRANLPR_ORG_ID);
commit;

/**  following code removed from regular results
--SAMPLE PREP
UPDATE FA_HABITAT_RESULT RE SET (SAMPLE_PREP_SOURCE,SAMPLE_PREP_NAME) =
	(SELECT LSPP.SOURCE_ACR,
		LSPP.NAME
	FROM storet1.TSRLSPP LSPP
	WHERE re.TSRLSPP_IS_NUMBER = LSPP.TSRLSPP_IS_NUMBER
	AND re.TSRLSPP_ORG_ID = LSPP.TSRLSPP_ORG_ID);
commit;
**/

--LAB
UPDATE FA_HABITAT_RESULT RE SET (LAB_ID,LAB_NAME) =
	(SELECT LAB.ID_CODE,
		LAB.NAME
	FROM storet1.TSRLAB LAB
	WHERE re.TSRLAB_IS_NUMBER = LAB.TSRLAB_IS_NUMBER
	AND re.ORGANIZATION_ID= LAB.TSRLAB_ORG_ID);
commit;

--QUANT LIMITS
UPDATE FA_HABITAT_RESULT RE SET (LOWER_QUANTITATION_LIMIT,UPPER_QUANTITATION_LIMIT,DETECTION_LIMIT,
	DETECTION_LIMIT_DESCRIPTION) =
	(SELECT DQL.MIN_QUANT_LIMIT,
		DQL.MAX_QUANT_LIMIT,
		DQL.MIN_DETECT_LIMIT||' '||UOM.SHORT_FORM_NAME,
		translate(DQL.DESCRIPTION_TEXT,chr(10)||chr(13)||chr(34)||chr(126),chr(182)||chr(182)||chr(96)||chr(94))
	FROM storet1.TSRDQL DQL, storet.TSRUOM UOM
 	WHERE re.RESULT_IS_NUMBER = DQL.TSRRSULT_IS_NUMBER
 		AND re.ORGANIZATION_ID = DQL.TSRRSULT_ORG_ID
 		AND DQL.TSRUOM_IS_NUMBER = UOM.TSRUOM_IS_NUMBER
 		AND DQL.TSRUOM_ORG_ID = UOM.TSRUOM_ORG_ID);
commit;

--FK_DATE
update FA_HABITAT_RESULT re set fk_date_act_start = (
	select da.pk_isn from di_date da
	where TO_CHAR(re.activity_start_date_time,'DD-MON-YYYY') = da.full_date);
commit;
/** no field_procedure_id for habitat 
--** new Activity Elements section **
--FIELD PROCEDURE
update FA_HABITAT_RESULT re
set (field_procedure_id) = (
	select id_code
	from storet1.TSRFLDPR fldpr
	where re.tsrfldpr_is_number = fldpr.tsrfldpr_is_number
	and re.ORGANIZATION_ID = fldpr.tsrfldpr_org_id);
commit;
**/
/** removed sample data fro regular results 
--SAMPLE
update FA_HABITAT_RESULT re
set (container_type,container_color,temperature_presrvtn_type,presrvtn_storage_procedure) = (
	select container_type_nm,container_color,temp_preservn_type,presrv_strge_prcdr
	from storet1.tsrsmple smple
	where re.activity_is_number = smple.tsrfdact_is_number
	and re.organization_id = smple.tsrfdact_org_id);
commit;
**/
/**  no gear data for habitat
--GEAR CONFIG
update FA_HABITAT_RESULT re
set (gear_config_id) = (
	select id_code
	from storet1.tsrgrcfg grcfg
	where re.tsrgrcfg_is_number = grcfg.tsrgrcfg_is_number
	and re.ORGANIZATION_ID = grcfg.tsrgrcfg_org_id);
commit;

--FIELD GEAR ID
update FA_HABITAT_RESULT re
set (field_gear_id) = (
	select id_code
	from storet.tsrfldgr fldgr
	where re.tsrfldgr_is_number = fldgr.tsrfldgr_is_number);
commit;
**/
/** no activity matrix for habitat
--ACTIVITY MATRIX
update FA_HABITAT_RESULT re
set (re.activity_matrix) = (
	select matrx.name
	from storet.tsrmatrx matrx
	where re.tsrmatrx_is_number = matrx.tsrmatrx_is_number);
commit;
**/
--GNTXT FIELDS
/**
update FA_HABITAT_RESULT re
set (re.result_comment) = (
	select description_text
	from storet1.tsmgntxt gntxt
	where gntxt.tsrrsult_org_id = re.organization_id
		AND gntxt.tsrrsult_is_number = re.result_is_number
		AND gntxt.description_name ='RSLTCMNT');
commit;

update FA_HABITAT_RESULT re
set (re.text_result) = (
	select description_text
	from storet1.tsmgntxt gntxt
	where gntxt.tsrrsult_org_id = re.organization_id
		AND gntxt.tsrrsult_is_number = re.result_is_number
		AND gntxt.description_name ='DESCRIPT');
commit;
**/
update FA_HABITAT_RESULT re
set (re.result_comment) = (
	select long_text
	from long_temp lt
	where lt.organization_id = re.organization_id
		AND lt.result_is_number = re.result_is_number
		AND lt.long_type ='RSLTCMNT');
commit;

update FA_HABITAT_RESULT re
set (re.text_result) = (
	select long_text
	from long_temp lt
	where lt.organization_id = re.organization_id
		AND lt.result_is_number = re.result_is_number
		AND lt.long_type ='DESCRIPT');
commit;

-- Lab Remarks
update FA_HABITAT_RESULT a
set a.LAB_REMARK= (select b.lbrmk from hblbrmk_temp b
       where b.tsrrsult_is_number = a.result_is_number
           and b.tsrrsult_org_id = a.organization_id);
commit;

-- FIELD SET
update FA_HABITAT_RESULT a
set a.field_set= (select b.field_set from hbfieldset_temp b
       where a.activity_isn = b.activity_isn);
commit;

-- SIMPLE FRACTION TYPE
update FA_HABITAT_RESULT re
set (SAMPLE_FRACTION_TYPE) = (
     select FIELD_VALUE
     from storet.TSMPRMVL b
     where b.tsmprmvl_is_number = re.tsmprmvl_is_number 
           and b.field_name = 'SMPL_FRAC_TYPE_NM'
           and b.table_name = 'TSRRSULT')
WHERE re.TSMPRMVL_IS_NUMBER IS NOT NULL;
commit;
--
--EPA registry num (edited for SIR 1677)
update FA_HABITAT_RESULT re
set re.EPA_REG_NUMBER = (
     select translate(als.char_alias,chr(10)||chr(13)||chr(34)||chr(126),chr(182)||chr(182)||chr(96)||chr(94))  
     from storetw.lu_char_alias als , storetw.lu_char_alias_type calt
     where re.fk_char = als.fk_characteristic
       and als.fk_char_alias_type = calt.pk_isn
       and calt.char_alias_type_name = 'EPA ID (SUBSTANCE REGISTRY)');
commit;
--

--Populate station location point information (updated 01-21-2004)
update fa_habitat_result re
set (fk_stn_act_pt) = (
	select pk_isn
	from fa_station st
	where re.tsmalp_is_number = st.tsmalp_is_number
	and re.organization_id = st.organization_id);

commit;

update fa_habitat_result re
set (fk_stn_act_pt) = (fk_station)
where fk_stn_act_pt is null;

commit;
spool off